public var doSmoothIcons:Bool = true;

var healthS = 1;
var percentS = 1;
var hpSmooth = 1;

function postUpdate(elapsed) { 
	if (!doSmoothIcons) return;

	healthS = FlxMath.bound(FlxMath.lerp(healthS, health, FlxMath.bound(elapsed * 20, 0, 1)), 0, maxHealth);

	healthBar.numDivisions = 10000;
	hpSmooth = FlxMath.lerp(hpSmooth, health * 50, elapsed * 20);
	healthBar.percent = hpSmooth;

	percentS = 1 - (healthS / 2);

	for (setup in iconList) {
		var icon:HealthIcon = setup[0];
		var onLeft:Bool = setup[1];

		var iconOffset:Int = 26;
		var center:Float = healthBar.x + healthBar.width * FlxMath.remapToRange(healthBar.percent, 0, 100, 1, 0);

		if (onLeft) {
			icon.x = center - (icon.width - iconOffset) - iconOffsets.get(icon).x;
			icon.health = 1 - (healthBar.percent / 100);
		} else {
			icon.x = center - iconOffset + iconOffsets.get(icon).x;
			icon.health = healthBar.percent / 100;
		}
		icon.y = FlxMath.lerp(icon.y, healthBar.y - (icon.height / 2) + iconOffsets.get(icon).y, FlxMath.bound(elapsed * 20, 0, 1));
	}
}